package easik.sketch.util.Export;

import java.io.File;

import javax.swing.JOptionPane;

import easik.Easik;
import easik.sketch.util.SketchFileIO;
import easik.ui.menu.FileSaveAction;


/**
 * A class to provide a method to save a sketch for SQL database generation if 
 * the sketch has been modified since the last use, and to initialize the SketchHandler
 * associated with the sketch.
 * 
 * @author Vera Ranieri 2006
 * @since 2006-05-18 Vera Ranieri 
 * @version 2006-06-27 Vera Ranieri
 *
 */
public class SaveForSQL {
	
	/**
	 * Prompts user if current sketch is unsaved.  Saves current sketch as XML file for SQL generation.
	 * Parses saved XML file for SQL translation.
	 * 
	 * @param platform The platform upon which the sketch is to be exported
	 * @return The ExportHandler, if one was successfully created.  <b>null</b> otherwise.
	 * @throws Exception If an error occurred while parsing XML.
	 */
	public static ExportHandler saveAction(String platform) throws Exception{
		
		// File needs to be saved before exporting.
		if(Easik.getInstance().getFrame().getSketch().getDirty() 
				|| Easik.getInstance().getFrame().getSketch().getFile()==null){
			
			int choice = JOptionPane.showConfirmDialog(null, 
					"File must be saved before exportation.  Continue?", 
					"Export File", JOptionPane.OK_CANCEL_OPTION);
			if(choice== JOptionPane.OK_OPTION){
				FileSaveAction.saveFile();
			}
			else{
				return null;
			}
		}
		
		File file = Easik.getInstance().getFrame().getSketch().getFile();
		if(file != null){
			ExportHandler sh = new ExportHandler(platform);
			
			
			//initialize sketchHandler.
			if(SketchFileIO.initializeExportHandlerFromXML(file, sh))
				return sh;
			
			//error occurred, so throw exception.
			else
				throw new Exception();
		}
		return null;
		
	}

}